/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby.mixin;

import de.johni0702.minecraft.bobby.Bobby;
import de.johni0702.minecraft.bobby.FakeChunk;
import de.johni0702.minecraft.bobby.FakeChunkManager;
import de.johni0702.minecraft.bobby.VisibleChunksTracker;
import de.johni0702.minecraft.bobby.ext.ClientChunkManagerExt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_631;
import net.minecraft.class_638;
import net.minecraft.class_6603;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_631.class})
public abstract class ClientChunkManagerMixin
implements ClientChunkManagerExt {
    @Shadow
    @Final
    private class_2818 field_3676;
    protected FakeChunkManager bobbyChunkManager;
    private final VisibleChunksTracker realChunksTracker = new VisibleChunksTracker();
    private final List<Pair<Long, Supplier<class_2818>>> bobbyChunkReplacements = new ArrayList<Pair<Long, Supplier<class_2818>>>();

    @Shadow
    @Nullable
    public abstract class_2818 method_2857(int var1, int var2, class_2806 var3, boolean var4);

    @Shadow
    private static int method_20230(int loadDistance) {
        throw new AssertionError();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void bobbyInit(class_638 world, int loadDistance, CallbackInfo ci) {
        if (Bobby.getInstance().isEnabled()) {
            this.bobbyChunkManager = new FakeChunkManager(world, (class_631)this);
            this.realChunksTracker.update(0, 0, ClientChunkManagerMixin.method_20230(loadDistance), null, null);
        }
    }

    @Override
    public FakeChunkManager bobby_getFakeChunkManager() {
        return this.bobbyChunkManager;
    }

    @Override
    public VisibleChunksTracker bobby_getRealChunksTracker() {
        return this.realChunksTracker;
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/chunk/ChunkStatus;Z)Lnet/minecraft/world/chunk/WorldChunk;"}, at={@At(value="RETURN")}, cancellable=true)
    private void bobbyGetChunk(int x, int z, class_2806 chunkStatus, boolean orEmpty, CallbackInfoReturnable<class_2818> ci) {
        if (ci.getReturnValue() != (orEmpty ? this.field_3676 : null)) {
            return;
        }
        if (this.bobbyChunkManager == null) {
            return;
        }
        class_2818 chunk = this.bobbyChunkManager.getChunk(x, z);
        if (chunk != null) {
            ci.setReturnValue((Object)chunk);
        }
    }

    @Inject(method={"loadChunkFromPacket"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientChunkManager$ClientChunkMap;getIndex(II)I")})
    private void bobbyUnloadFakeChunk(int x, int z, class_2540 buf, Map<class_2902.class_2903, long[]> heightmaps, Consumer<class_6603.class_6605> consumer, CallbackInfoReturnable<class_2818> cir) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        this.bobbyChunkManager.unload(x, z, true);
    }

    @Inject(method={"loadChunkFromPacket"}, at={@At(value="RETURN")})
    private void bobbyFingerprintRealChunk(CallbackInfoReturnable<class_2818> cir) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        class_2818 chunk = (class_2818)cir.getReturnValue();
        if (chunk == null) {
            return;
        }
        this.bobbyChunkManager.fingerprint(chunk);
    }

    @Unique
    private void saveRealChunk(long chunkPos) {
        int chunkZ;
        int chunkX = class_1923.method_8325((long)chunkPos);
        class_2818 chunk = this.method_2857(chunkX, chunkZ = class_1923.method_8332((long)chunkPos), class_2806.field_12803, false);
        if (chunk == null || chunk instanceof FakeChunk) {
            return;
        }
        Supplier<class_2818> copy = this.bobbyChunkManager.save(chunk);
        if (this.bobbyChunkManager.shouldBeLoaded(chunkX, chunkZ)) {
            this.bobbyChunkReplacements.add((Pair<Long, Supplier<class_2818>>)Pair.of((Object)chunkPos, copy));
        }
    }

    @Unique
    private void substituteFakeChunksForUnloadedRealOnes() {
        for (Pair<Long, Supplier<class_2818>> entry : this.bobbyChunkReplacements) {
            long chunkPos = (Long)entry.getKey();
            int chunkX = class_1923.method_8325((long)chunkPos);
            int chunkZ = class_1923.method_8332((long)chunkPos);
            this.bobbyChunkManager.load(chunkX, chunkZ, (class_2818)((Supplier)entry.getValue()).get());
        }
        this.bobbyChunkReplacements.clear();
    }

    @Inject(method={"unload"}, at={@At(value="HEAD")})
    private void bobbySaveChunk(class_1923 pos, CallbackInfo ci) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        this.saveRealChunk(pos.method_8324());
    }

    @Inject(method={"setChunkMapCenter"}, at={@At(value="HEAD")})
    private void bobbySaveChunksBeforeMove(int x, int z, CallbackInfo ci) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        this.realChunksTracker.updateCenter(x, z, this::saveRealChunk, null);
    }

    @Inject(method={"updateLoadDistance"}, at={@At(value="HEAD")})
    private void bobbySaveChunksBeforeResize(int loadDistance, CallbackInfo ci) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        this.realChunksTracker.updateViewDistance(ClientChunkManagerMixin.method_20230(loadDistance), this::saveRealChunk, null);
    }

    @Inject(method={"unload", "setChunkMapCenter", "updateLoadDistance"}, at={@At(value="RETURN")})
    private void bobbySubstituteFakeChunksForUnloadedRealOnes(CallbackInfo ci) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        this.substituteFakeChunksForUnloadedRealOnes();
    }

    @Inject(method={"updateLoadDistance"}, at={@At(value="FIELD", target="Lnet/minecraft/client/world/ClientChunkManager;chunks:Lnet/minecraft/client/world/ClientChunkManager$ClientChunkMap;", opcode=181, shift=At.Shift.AFTER)})
    private void reAddEmptyFakeChunks(CallbackInfo ci) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        for (class_2818 chunk : this.bobbyChunkManager.getFakeChunks()) {
            class_1923 pos = chunk.method_12004();
            this.bobbyChunkManager.loadEmptySectionsOfFakeChunk(pos.field_9181, pos.field_9180, chunk);
        }
    }

    @Inject(method={"getDebugString"}, at={@At(value="RETURN")}, cancellable=true)
    private void bobbyDebugString(CallbackInfoReturnable<String> cir) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        cir.setReturnValue((Object)((String)cir.getReturnValue() + " " + this.bobbyChunkManager.getDebugString()));
    }

    @Override
    public void bobby_onFakeChunkAdded(int x, int z) {
    }

    @Override
    public void bobby_onFakeChunkRemoved(int x, int z, boolean willBeReplaced) {
    }
}

