/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.config;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10716;
import net.minecraft.class_10717;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.mixin.LeavesBlockAccessor;
import randommcsomethin.fallingleaves.particle.ParticleImplementation;

public class ConfigDefaults {
    public static float DEFAULT_SPAWN_CHANCE = 0.01f;

    public static ParticleImplementation getImplementation(class_2960 blockId) {
        if (ConfigDefaults.useCustomCherryImplementation(blockId)) {
            return ParticleImplementation.CHERRY;
        }
        if (ConfigDefaults.isConifer(blockId)) {
            return ParticleImplementation.CONIFER;
        }
        if (ConfigDefaults.useVanillaParticles(blockId)) {
            return ParticleImplementation.VANILLA;
        }
        return ParticleImplementation.REGULAR;
    }

    public static boolean useVanillaParticles(class_2960 blockId) {
        class_2248 b = (class_2248)class_7923.field_41175.method_63535(blockId);
        if (!(b instanceof class_2397)) {
            return false;
        }
        if (!(b instanceof class_10716) && !(b instanceof class_10717)) {
            FallingLeavesClient.LOGGER.debug("{} is neither Tinted nor Untinted", (Object)b);
            return true;
        }
        if (b instanceof class_10717) {
            FallingLeavesClient.LOGGER.debug("{} is Untinted", (Object)b);
            return true;
        }
        if (b.getClass() == class_10716.class) {
            return false;
        }
        if (b instanceof class_10716) {
            try {
                String methodName = FabricLoader.getInstance().isDevelopmentEnvironment() ? "spawnLeafParticle" : "method_67234";
                b.getClass().getDeclaredMethod(methodName, class_1937.class, class_2338.class, class_5819.class);
                FallingLeavesClient.LOGGER.debug("{} implements spawnLeafParticle", (Object)b);
                return true;
            }
            catch (NoSuchMethodException e) {
                FallingLeavesClient.LOGGER.debug("{} does not implement spawnLeafParticle", (Object)b);
                return false;
            }
        }
        FallingLeavesClient.LOGGER.warn("{} has unhandled useVanillaParticles default", (Object)b);
        return false;
    }

    public static boolean useCustomCherryImplementation(class_2960 blockId) {
        return false;
    }

    public static boolean isConifer(class_2960 blockId) {
        switch (blockId.toString()) {
            case "bewitchment:cypress_leaves": 
            case "bewitchment:dragons_blood_leaves": 
            case "bewitchment:juniper_leaves": 
            case "biomemakeover:swamp_cypress_leaves": 
            case "byg:araucaria_leaves": 
            case "byg:blue_spruce_leaves": 
            case "byg:cypress_leaves": 
            case "byg:fir_leaves": 
            case "byg:orange_spruce_leaves": 
            case "byg:pine_leaves": 
            case "byg:red_spruce_leaves": 
            case "byg:redwood_leaves": 
            case "byg:yellow_spruce_leaves": 
            case "minecraft:spruce_leaves": 
            case "terrestria:cypress_leaves": 
            case "terrestria:hemlock_leaves": 
            case "terrestria:redwood_leaves": 
            case "traverse:fir_leaves": 
            case "woods_and_mires:pine_leaves": {
                return true;
            }
        }
        return false;
    }

    public static float spawnRateFactor(class_2960 blockId) {
        switch (blockId.toString()) {
            case "byg:palm_leaves": 
            case "minecraft:jungle_leaves": 
            case "promenade:palm_leaves": 
            case "terrestria:japanese_maple_shrub_leaves": 
            case "terrestria:jungle_palm_leaves": 
            case "terrestria:yucca_palm_leaves": {
                return 0.0f;
            }
        }
        class_2248 block = (class_2248)class_7923.field_41175.method_63535(blockId);
        if (!(block instanceof LeavesBlockAccessor)) {
            return 1.0f;
        }
        LeavesBlockAccessor leavesBlock = (LeavesBlockAccessor)block;
        float chance = leavesBlock.getLeafParticleChance();
        float factor = chance / DEFAULT_SPAWN_CHANCE;
        if (factor != 1.0f) {
            FallingLeavesClient.LOGGER.debug("block {} has leaf particle chance {}, factor = {}", (Object)blockId, (Object)Float.valueOf(chance), (Object)Float.valueOf(factor));
        }
        return factor;
    }

    public static boolean spawnBreakingLeaves(class_2960 blockId) {
        return true;
    }
}

