/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public interface JsonObjectWriter
extends AutoCloseable {
    public static JsonObjectWriter of(JsonWriter writer) throws IOException {
        writer.setIndent("    ");
        return () -> writer;
    }

    public JsonWriter writer();

    default public void field(String name, String data) throws IOException {
        this.writer().name(name);
        this.writer().value(data);
    }

    default public void field(String name, int data) throws IOException {
        this.writer().name(name);
        this.writer().value((long)data);
    }

    default public void field(String name, long data) throws IOException {
        this.writer().name(name);
        this.writer().value(data);
    }

    default public void field(String name, float data) throws IOException {
        this.writer().name(name);
        this.writer().value(data);
    }

    default public void field(String name, WriteAction action) throws IOException {
        this.writer().name(name);
        action.write();
    }

    default public void object(WriteAction action) throws IOException {
        this.writer().beginObject();
        action.write();
        this.writer().endObject();
    }

    default public void object(String name, WriteAction action) throws IOException {
        this.writer().name(name);
        this.object(action);
    }

    default public void array(String name, WriteAction action) throws IOException {
        this.writer().name(name);
        this.array(action);
    }

    default public void array(WriteAction action) throws IOException {
        this.writer().beginArray();
        action.write();
        this.writer().endArray();
    }

    default public <T> void each(Iterable<T> iterable, WriteConsumer<T> action) throws IOException {
        for (T t : iterable) {
            action.write(t);
        }
    }

    @Override
    default public void close() throws IOException {
        this.writer().close();
    }

    public static interface WriteAction {
        public void write() throws IOException;
    }

    public static interface WriteConsumer<T> {
        public void write(T var1) throws IOException;
    }
}

