/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.api.DerivedBlock;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.PrimitiveLookup;
import eu.ha3.presencefootsteps.world.Solver;
import eu.ha3.presencefootsteps.world.SoundsKey;
import eu.ha3.presencefootsteps.world.Substrates;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2498;
import net.minecraft.class_2680;

public final class AssociationPool {
    private final class_1309 entity;
    private final SoundEngine engine;
    private final Solver solver;
    private boolean wasGolem;
    private SoundsKey association;

    public AssociationPool(class_1309 entity, SoundEngine engine) {
        this.entity = entity;
        this.engine = engine;
        this.solver = engine.getSolver();
    }

    public void reset() {
        this.wasGolem = false;
    }

    public boolean wasLastMatchGolem() {
        return this.wasGolem;
    }

    public Association findAssociation(double verticalOffsetAsMinus, boolean isRightFoot) {
        return this.solver.findAssociation(this, this.entity, verticalOffsetAsMinus, isRightFoot);
    }

    public Association findAssociation(class_2338 pos, String strategy) {
        return this.solver.findAssociation(this, this.entity, pos, strategy);
    }

    public SoundsKey get(class_2338 pos, class_2680 state, String substrate) {
        for (class_1297 golem : this.entity.method_37908().method_8333((class_1297)this.entity, new class_238(pos).method_1009(0.5, 0.0, 0.5), e -> !e.method_30948((class_1297)this.entity) || e.method_5829().field_1325 < this.entity.method_23318() + (double)0.2f)) {
            this.association = this.engine.getIsolator().golems().getAssociation(golem.method_5864(), substrate);
            if (!this.association.isEmitter()) continue;
            this.wasGolem = true;
            return this.association;
        }
        class_2680 baseState = DerivedBlock.getBaseOf(state);
        if (state.method_26215()) {
            return SoundsKey.UNASSIGNED;
        }
        if (this.getForState(state, substrate) || !baseState.method_26215() && (this.getForState(baseState, substrate) || !Substrates.isDefault(substrate) && this.getForState(baseState, "") || this.getForPrimitive(baseState, substrate)) || this.getForPrimitive(state, substrate)) {
            return this.association;
        }
        return SoundsKey.UNASSIGNED;
    }

    private boolean getForState(class_2680 state, String substrate) {
        this.association = this.engine.getIsolator().blocks(this.entity.method_5864()).getAssociation(state, substrate);
        return this.association.isResult();
    }

    private boolean getForPrimitive(class_2680 state, String substrate) {
        if (Substrates.isSupplimentary(substrate)) {
            return false;
        }
        class_2498 sounds = state.method_26231();
        this.association = this.engine.getIsolator().primitives().getAssociation(sounds.method_10594(), PrimitiveLookup.getSubstrate(sounds));
        return this.association.isResult();
    }
}

