/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Config;
import dev.terminalmc.commandkeys.config.Keybind;
import dev.terminalmc.commandkeys.config.Message;
import dev.terminalmc.commandkeys.util.JsonUtil;
import dev.terminalmc.commandkeys.util.Localization;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3675;
import org.jetbrains.annotations.Nullable;

public class Macro {
    public static final int VERSION = 6;
    public final int version = 6;
    public static final Random RANDOM = new Random();
    boolean addToHistory;
    public static final boolean addToHistoryDefault = false;
    transient boolean addToHistoryStatus;
    boolean showHudMessage;
    public static final boolean showHudMessageDefault = false;
    transient boolean showHudMessageStatus;
    boolean resumeRepeating;
    public static final boolean resumeRepeatingDefault = false;
    transient boolean resumeRepeatingStatus;
    boolean useRatelimit;
    public static final boolean useRatelimitDefault = true;
    transient boolean useRatelimitStatus;
    ConflictStrategy conflictStrategy;
    public static final ConflictStrategy conflictStrategyDefault = ConflictStrategy.SUBMIT;
    SendMode sendMode;
    public static final SendMode sendModeDefault = SendMode.SEND;
    ActivationType activationType;
    public static final ActivationType activationTypeDefault = ActivationType.HOLD;
    public int spaceTicks;
    public static final int spaceTicksDefault = 0;
    public transient int cycleIndex;
    public static final int cycleIndexDefault = 0;
    Keybind keybind;
    public static final Supplier<Keybind> keybindDefault = Keybind::new;
    Keybind altKeybind;
    public static final Supplier<Keybind> altKeybindDefault = Keybind::new;
    final List<Message> messages;
    public static final Supplier<List<Message>> messagesDefault = ArrayList::new;
    private transient boolean active = false;
    private transient int activeTicks = 0;
    private final transient List<ScheduledMessage> scheduledMessages = new ArrayList<ScheduledMessage>();

    public Macro() {
        this(false, false, false, true, Config.get().defaultConflictStrategy, Config.get().defaultSendMode, Config.get().defaultActivationType, 0, 0, keybindDefault.get(), altKeybindDefault.get(), messagesDefault.get());
    }

    Macro(boolean addToHistory, boolean showHudMessage, boolean resumeRepeating, boolean useRatelimit, ConflictStrategy conflictStrategy, SendMode sendMode, ActivationType activationType, int spaceTicks, int cycleIndex, Keybind keybind, Keybind altKeybind, List<Message> messages) {
        this.addToHistory = addToHistory;
        this.showHudMessage = showHudMessage;
        this.resumeRepeating = resumeRepeating;
        this.useRatelimit = useRatelimit;
        this.conflictStrategy = conflictStrategy;
        this.sendMode = sendMode;
        this.activationType = activationType;
        this.spaceTicks = spaceTicks;
        this.cycleIndex = cycleIndex;
        this.keybind = keybind;
        this.altKeybind = altKeybind;
        this.messages = messages;
    }

    Macro(Macro macro) {
        this.addToHistory = macro.addToHistory;
        this.addToHistoryStatus = macro.addToHistoryStatus;
        this.showHudMessage = macro.showHudMessage;
        this.showHudMessageStatus = macro.showHudMessageStatus;
        this.resumeRepeating = macro.resumeRepeating;
        this.resumeRepeatingStatus = macro.resumeRepeatingStatus;
        this.useRatelimit = macro.useRatelimit;
        this.useRatelimitStatus = macro.useRatelimitStatus;
        this.conflictStrategy = macro.conflictStrategy;
        this.sendMode = macro.sendMode;
        this.activationType = macro.activationType;
        this.spaceTicks = macro.spaceTicks;
        this.cycleIndex = macro.cycleIndex;
        this.keybind = new Keybind(macro.keybind);
        this.altKeybind = new Keybind(macro.altKeybind);
        this.messages = macro.messages.stream().map(Message::new).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean getAddToHistory() {
        return this.addToHistory;
    }

    public boolean getAddToHistoryStatus() {
        return this.addToHistoryStatus;
    }

    public boolean getShowHudMessage() {
        return this.showHudMessage;
    }

    public boolean getShowHudMessageStatus() {
        return this.showHudMessageStatus;
    }

    public boolean getResumeRepeating() {
        return this.resumeRepeating;
    }

    public boolean getResumeRepeatingStatus() {
        return this.resumeRepeatingStatus;
    }

    public boolean getUseRatelimit() {
        return this.useRatelimit;
    }

    public boolean getUseRatelimitStatus() {
        return this.useRatelimitStatus;
    }

    public ConflictStrategy getStrategy() {
        return this.conflictStrategy;
    }

    public SendMode getMode() {
        return this.sendMode;
    }

    public ActivationType getActivationType() {
        return this.activationType;
    }

    public Keybind getKeybind() {
        return this.keybind;
    }

    public Keybind getAltKeybind() {
        return this.altKeybind;
    }

    public boolean ownsKeybind(Keybind keybind) {
        return keybind == this.keybind || keybind == this.altKeybind;
    }

    public boolean usesAltKeybind() {
        return this.sendMode.equals((Object)SendMode.CYCLE);
    }

    public List<Message> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public void addMessage(Message message) {
        this.messages.add(message);
    }

    public void setMessage(int index, String str) {
        this.messages.get((int)index).string = str;
    }

    public void removeMessage(int index) {
        this.messages.remove(index);
    }

    public boolean moveMessage(int sourceIndex, int destIndex) {
        if (sourceIndex != destIndex) {
            this.messages.add(destIndex, this.messages.remove(sourceIndex));
            return true;
        }
        return false;
    }

    public void tick() {
        this.scheduledMessages.removeIf(ScheduledMessage::tick);
        if (this.active) {
            if (this.activationType == ActivationType.HOLD && !this.keybind.isKeyDown()) {
                this.deactivate();
            } else {
                switch (this.sendMode.ordinal()) {
                    case 4: {
                        if (this.spaceTicks != 0 && (this.activeTicks <= 0 || this.activeTicks % this.spaceTicks != 0)) break;
                        this.scheduleAll(false);
                    }
                }
                ++this.activeTicks;
            }
        }
    }

    public boolean trigger(@Nullable Keybind keybind, boolean ratelimited) {
        if (this.active) {
            this.singleActionComplete();
        } else {
            if (keybind != null && this.useRatelimitStatus && !CommandKeys.canTrigger(keybind.getKey(), !ratelimited)) {
                return true;
            }
            this.activate(keybind);
        }
        return false;
    }

    public void deactivate() {
        this.active = false;
    }

    public void deactivateAndCancel() {
        this.deactivate();
        this.clearScheduled();
    }

    private void singleActionComplete() {
        if (this.activationType != ActivationType.HOLD) {
            this.deactivate();
        }
    }

    private void activate(@Nullable Keybind keybind) {
        this.active = true;
        this.activeTicks = -1;
        switch (this.sendMode.ordinal()) {
            case 0: {
                this.scheduleAll(this.spaceTicks != 0);
                this.singleActionComplete();
                break;
            }
            case 4: {
                this.scheduleAll(false);
                break;
            }
            case 1: {
                if (!this.messages.isEmpty()) {
                    CommandKeys.type(this.messages.getFirst().string);
                }
                this.singleActionComplete();
                break;
            }
            case 2: {
                if (this.altKeybind.equals(keybind)) {
                    if (--this.cycleIndex < 0) {
                        this.cycleIndex = this.messages.size() - 1;
                    }
                } else if (++this.cycleIndex >= this.messages.size()) {
                    this.cycleIndex = 0;
                }
                for (String str : this.messages.get((int)this.cycleIndex).string.split(",,")) {
                    if (str.isBlank()) continue;
                    this.schedule(this.messages.get((int)this.cycleIndex).delayTicks, str, this.addToHistoryStatus, this.showHudMessageStatus);
                }
                this.singleActionComplete();
                break;
            }
            case 3: {
                if (!this.messages.isEmpty()) {
                    Message msg = this.messages.get(RANDOM.nextInt(this.messages.size()));
                    if (!msg.string.isBlank()) {
                        this.schedule(msg.delayTicks, msg.string, this.addToHistoryStatus, this.showHudMessageStatus);
                    }
                }
                this.singleActionComplete();
            }
        }
    }

    private void schedule(int delay, String message, boolean addToHistory, boolean showHudMessage) {
        if (delay > 0) {
            this.scheduledMessages.add(new ScheduledMessage(delay, message, addToHistory, showHudMessage));
        } else {
            CommandKeys.send(message, showHudMessage, addToHistory);
        }
    }

    private void scheduleAll(boolean standardDelay) {
        int totalDelay = standardDelay ? -this.spaceTicks : 0;
        for (Message msg : this.messages) {
            totalDelay += standardDelay ? this.spaceTicks : msg.delayTicks;
            if (msg.string.isBlank()) continue;
            this.schedule(totalDelay, msg.string, this.addToHistoryStatus, this.showHudMessageStatus);
        }
    }

    private void clearScheduled() {
        this.scheduledMessages.clear();
    }

    Macro validate() {
        if (this.spaceTicks < 0) {
            this.spaceTicks = 0;
        }
        this.keybind.validate();
        this.altKeybind.validate();
        this.messages.forEach(Message::validate);
        this.cleanupMessages();
        return this;
    }

    void cleanupMessages() {
        this.messages.removeIf(msg -> {
            msg.string = msg.string.stripLeading();
            if (!this.sendMode.equals((Object)SendMode.TYPE)) {
                msg.string = msg.string.stripTrailing();
            }
            return msg.string.isBlank() && !this.sendMode.equals((Object)SendMode.CYCLE) && !this.sendMode.equals((Object)SendMode.TYPE);
        });
    }

    public static enum ConflictStrategy {
        SUBMIT(class_124.field_1060),
        ASSERT(class_124.field_1065),
        VETO(class_124.field_1061),
        AVOID(class_124.field_1075);

        private final class_124 style;

        private ConflictStrategy(class_124 style) {
            this.style = style;
        }

        public class_2561 title() {
            return Localization.localized("option", "macro.conflict." + this.name(), new Object[0]).method_27692(this.style);
        }

        public class_2561 tooltip() {
            return Localization.localized("option", "macro.conflict." + this.name() + ".tooltip", new Object[0]);
        }
    }

    public static enum SendMode {
        SEND(class_124.field_1060),
        TYPE(class_124.field_1065),
        CYCLE(class_124.field_1075),
        RANDOM(class_124.field_1076),
        REPEAT(class_124.field_1061);

        private final class_124 style;

        private SendMode(class_124 style) {
            this.style = style;
        }

        public class_2561 title() {
            return Localization.localized("option", "macro.send." + this.name(), new Object[0]).method_27692(this.style);
        }

        public class_2561 tooltip() {
            return Localization.localized("option", "macro.send." + this.name() + ".tooltip", new Object[0]);
        }
    }

    public static enum ActivationType {
        HOLD(class_124.field_1060),
        VANILLA(class_124.field_1065);

        private final class_124 style;

        private ActivationType(class_124 style) {
            this.style = style;
        }

        public class_2561 title() {
            return Localization.localized("option", "macro.activation." + this.name(), new Object[0]).method_27692(this.style);
        }

        public class_2561 tooltip() {
            return Localization.localized("option", "macro.activation." + this.name() + ".tooltip", new Object[0]);
        }
    }

    private static class ScheduledMessage {
        private int delay;
        final String message;
        final boolean showHudMessage;
        final boolean addToHistory;

        public ScheduledMessage(int delay, String message, boolean showHudMessage, boolean addToHistory) {
            this.delay = delay;
            this.message = message;
            this.showHudMessage = showHudMessage;
            this.addToHistory = addToHistory;
        }

        private boolean tick() {
            if (--this.delay <= 0) {
                CommandKeys.send(this.message, this.showHudMessage, this.addToHistory);
                return true;
            }
            return false;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<Macro> {
        public Macro deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.has("version") ? obj.get("version").getAsInt() : 0;
            boolean silent = version != 6;
            boolean addToHistory = JsonUtil.getOrDefault(obj, "addToHistory", false, silent);
            boolean showHudMessage = JsonUtil.getOrDefault(obj, "showHudMessage", false, silent);
            boolean resumeRepeating = JsonUtil.getOrDefault(obj, "resumeRepeating", false, silent);
            boolean useRatelimit = JsonUtil.getOrDefault(obj, "useRatelimit", true, silent);
            ConflictStrategy conflictStrategy = version >= 3 ? JsonUtil.getOrDefault(obj, "conflictStrategy", ConflictStrategy.class, conflictStrategyDefault, silent) : Deserializer.getConflictStrategy(JsonUtil.getOrDefault(obj, "conflictStrategy", "", true));
            SendMode sendMode = version >= 3 ? JsonUtil.getOrDefault(obj, "sendMode", SendMode.class, sendModeDefault, silent) : Deserializer.getSendMode(JsonUtil.getOrDefault(obj, "sendMode", "", true));
            ActivationType activationType = JsonUtil.getOrDefault(obj, "activationType", ActivationType.class, activationTypeDefault, silent);
            int spaceTicks = JsonUtil.getOrDefault(obj, "spaceTicks", 0, silent);
            Keybind keybind = version >= 4 ? JsonUtil.getOrDefault(ctx, obj, "keybind", Keybind.class, new Keybind(), silent) : new Keybind(JsonUtil.getOrDefault(obj, "keyName", class_3675.field_16237, true), JsonUtil.getOrDefault(obj, "limitKeyName", class_3675.field_16237, true)).validate();
            Keybind altKeybind = JsonUtil.getOrDefault(ctx, obj, "altKeybind", Keybind.class, new Keybind(), silent);
            List<Message> messages = JsonUtil.getOrDefault(ctx, obj, "messages", Message.class, messagesDefault.get(), silent);
            return new Macro(addToHistory, showHudMessage, resumeRepeating, useRatelimit, conflictStrategy, sendMode, activationType, spaceTicks, 0, keybind, altKeybind, messages).validate();
        }

        public static ConflictStrategy getConflictStrategy(String str) {
            return switch (str) {
                case "ZERO" -> ConflictStrategy.SUBMIT;
                case "ONE" -> ConflictStrategy.ASSERT;
                case "TWO" -> ConflictStrategy.VETO;
                case "THREE" -> ConflictStrategy.AVOID;
                default -> conflictStrategyDefault;
            };
        }

        public static SendMode getSendMode(String str) {
            return switch (str) {
                case "ZERO" -> SendMode.SEND;
                case "ONE" -> SendMode.TYPE;
                case "TWO" -> SendMode.CYCLE;
                default -> sendModeDefault;
            };
        }
    }
}

