/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.util;

import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Keybind;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.terminalmc.commandkeys.mixin.accessor.KeyMappingAccessor;
import dev.terminalmc.commandkeys.util.Localization;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class KeybindUtil {
    public static int handleKeys(class_3675.class_306 key, class_3675.class_306 limitKey) {
        if (key.equals((Object)class_3675.field_16237)) {
            return 0;
        }
        if (!CommandKeys.profile().keybindMap.containsKey((Object)key)) {
            return 0;
        }
        int i = 0;
        Collection keybinds = CommandKeys.profile().keybindMap.get((Object)key);
        for (Keybind keybind : keybinds) {
            if (!keybind.getLimitKey().equals((Object)limitKey)) continue;
            for (Macro macro : CommandKeys.profile().macroMap.get((Object)keybind)) {
                macro.trigger(keybind, false);
                ++i;
            }
        }
        return i;
    }

    public static int handleKey(class_3675.class_306 key) {
        int cancel = 0;
        if (class_310.method_1551().field_1755 == null && CommandKeys.profile().keybindMap.containsKey((Object)key)) {
            Collection keybinds = CommandKeys.profile().keybindMap.get((Object)key);
            Keybind triggerKb = null;
            List<Macro> macros = null;
            for (Keybind kb : keybinds) {
                if (kb.isLimitKeyDown()) {
                    triggerKb = kb;
                    macros = CommandKeys.profile().macroMap.get((Object)triggerKb).stream().filter(macro -> !macro.getStrategy().equals((Object)Macro.ConflictStrategy.AVOID)).toList();
                    if (macros.isEmpty()) continue;
                    break;
                }
                if (!kb.getLimitKey().equals((Object)class_3675.field_16237)) continue;
                triggerKb = kb;
            }
            if (macros == null || macros.isEmpty()) {
                if (triggerKb == null) {
                    return cancel;
                }
                macros = CommandKeys.profile().macroMap.get(triggerKb).stream().filter(macro -> !macro.getStrategy().equals((Object)Macro.ConflictStrategy.AVOID)).toList();
                if (macros.isEmpty()) {
                    return cancel;
                }
            }
            boolean ratelimited = false;
            for (Macro macro2 : macros) {
                boolean send = true;
                switch (macro2.getStrategy()) {
                    case SUBMIT: {
                        send = KeybindUtil.getConflict(key) == null;
                        break;
                    }
                    case VETO: {
                        cancel = 2;
                    }
                }
                if (!send) continue;
                boolean rl = macro2.trigger(triggerKb, ratelimited);
                if (!rl && cancel == 0 && macro2.getMode().equals((Object)Macro.SendMode.TYPE)) {
                    cancel = 1;
                }
                ratelimited |= rl;
            }
        }
        return cancel;
    }

    @Nullable
    public static class_304 getConflict(class_3675.class_306 key) {
        for (class_304 keyMapping : class_310.method_1551().field_1690.field_1839) {
            if (!((KeyMappingAccessor)keyMapping).commandkeys$getKey().equals((Object)key)) continue;
            return keyMapping;
        }
        return null;
    }

    public static class KeybindInfo {
        private final Profile profile;
        private final Macro macro;
        public class_5250 label;
        public class_5250 conflictLabel;
        public class_5250 tooltip = class_2561.method_43473();
        private boolean internalConflict = false;
        private boolean mcConflict = false;

        public KeybindInfo(Profile profile, Macro macro, Keybind keybind) {
            this.profile = profile;
            this.macro = macro;
            this.label = keybind.getLimitKey().equals((Object)class_3675.field_16237) ? keybind.getKey().method_27445().method_27661() : keybind.getLimitKey().method_27445().method_27661().method_27693(" + ").method_10852(keybind.getKey().method_27445());
            this.checkConflict(keybind.getLimitKey(), null);
            this.checkConflict(keybind.getKey(), keybind);
            this.createConflictLabel();
        }

        private void checkConflict(class_3675.class_306 key, Keybind keybind) {
            class_304 keyMapping;
            if (key.equals((Object)class_3675.field_16237)) {
                return;
            }
            if (this.profile.keybindMap.get((Object)key).size() > 1) {
                if (this.internalConflict || this.mcConflict) {
                    this.tooltip.method_27693("\n");
                }
                this.tooltip.method_10852((class_2561)Localization.localized("option", "macro.bind.tooltip.conflict.internal", key.method_27445().method_27661().method_27692(class_124.field_1065))).method_27692(class_124.field_1068);
                this.internalConflict = true;
            } else if (keybind != null && this.profile.macroMap.get((Object)keybind).size() > 1) {
                if (this.internalConflict || this.mcConflict) {
                    this.tooltip.method_27693("\n");
                }
                this.tooltip.method_10852((class_2561)Localization.localized("option", "macro.bind.tooltip.conflict.internal", key.method_27445().method_27661().method_27692(class_124.field_1065))).method_27692(class_124.field_1068);
                this.internalConflict = true;
            }
            if (!this.macro.getStrategy().equals((Object)Macro.ConflictStrategy.AVOID) && (keyMapping = KeybindUtil.getConflict(key)) != null) {
                if (this.internalConflict || this.mcConflict) {
                    this.tooltip.method_27693("\n");
                }
                this.tooltip.method_10852((class_2561)Localization.localized("option", "macro.bind.tooltip.conflict.external", key.method_27445().method_27661().method_27692(class_124.field_1061), class_2561.method_43471((String)keyMapping.method_1431()).method_27692(class_124.field_1080))).method_27692(class_124.field_1068);
                this.mcConflict = true;
            }
        }

        public void createConflictLabel() {
            if (this.mcConflict) {
                this.conflictLabel = class_2561.method_43470((String)"[ ").method_10852((class_2561)this.label.method_27692(class_124.field_1068)).method_27693(" ]").method_27692(class_124.field_1061);
                this.tooltip.method_27693("\n");
                this.tooltip.method_10852((class_2561)Localization.localized("option", "macro.bind.tooltip.conflictStrategy", this.macro.getStrategy().tooltip()));
            } else {
                this.conflictLabel = this.internalConflict ? class_2561.method_43470((String)"[ ").method_10852((class_2561)this.label.method_27692(class_124.field_1068)).method_27693(" ]").method_27692(class_124.field_1065) : this.label;
            }
        }
    }
}

