/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.config.Config;
import me.chrr.scribble.config.DeprecatedConfigOption;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).addSerializationExclusionStrategy((ExclusionStrategy)new SkipDeprecatedStrategy()).setPrettyPrinting().create();
    private Config config = new Config();

    public Config getConfig() {
        return this.config;
    }

    public void load() throws IOException {
        Path path = this.getConfigPath();
        if (path.toFile().isFile()) {
            this.config = (Config)GSON.fromJson(Files.readString(path), Config.class);
            this.config.upgrade();
        }
        this.save();
    }

    public void save() throws IOException {
        Files.writeString(this.getConfigPath(), (CharSequence)GSON.toJson((Object)this.config), new OpenOption[0]);
    }

    private Path getConfigPath() {
        return Scribble.CONFIG_DIR.resolve("scribble.json");
    }

    private static class SkipDeprecatedStrategy
    implements ExclusionStrategy {
        private SkipDeprecatedStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getAnnotation(DeprecatedConfigOption.class) != null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }
}

