/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.api.util;

import net.caffeinemc.mods.sodium.api.util.ColorU8;
import org.jetbrains.annotations.ApiStatus;

public class ColorMixer {
    public static int mix(int start, int end, int weight) {
        long hi = ((long)start & 0xFF00FFL) * (long)weight + ((long)end & 0xFF00FFL) * (long)(255 - weight);
        long lo = ((long)start & 0xFF00FF00L) * (long)weight + ((long)end & 0xFF00FF00L) * (long)(255 - weight);
        long result = hi + 0xFF00FFL >>> 8 & 0xFF00FFL | lo + 0xFF00FF00L >>> 8 & 0xFF00FF00L;
        return (int)result;
    }

    public static int mix(int start, int end, float weight) {
        return ColorMixer.mix(start, end, ColorU8.normalizedFloatToByte(weight));
    }

    @ApiStatus.Experimental
    public static int mix2d(int m00, int m01, int m10, int m11, float x, float y) {
        int x1 = ColorU8.normalizedFloatToByte(x);
        int x0 = 255 - x1;
        int y1 = ColorU8.normalizedFloatToByte(y);
        int y0 = 255 - y1;
        long row0a = ((long)m00 & 0xFF00FFL) * (long)x0 + ((long)m10 & 0xFF00FFL) * (long)x1 + 0xFF00FFL >>> 8 & 0xFF00FFL;
        long row0b = ((long)m00 & 0xFF00FF00L) * (long)x0 + ((long)m10 & 0xFF00FF00L) * (long)x1 + 0xFF00FF00L >>> 8 & 0xFF00FF00L;
        long row1a = ((long)m01 & 0xFF00FFL) * (long)x0 + ((long)m11 & 0xFF00FFL) * (long)x1 + 0xFF00FFL >>> 8 & 0xFF00FFL;
        long row1b = ((long)m01 & 0xFF00FF00L) * (long)x0 + ((long)m11 & 0xFF00FF00L) * (long)x1 + 0xFF00FF00L >>> 8 & 0xFF00FF00L;
        long result = row0a * (long)y0 + row1a * (long)y1 + 0xFF00FFL >>> 8 & 0xFF00FFL | row0b * (long)y0 + row1b * (long)y1 + 0xFF00FF00L >>> 8 & 0xFF00FF00L;
        return (int)result;
    }

    public static int mulComponentWise(int color0, int color1) {
        int comp0 = (color0 >>> 0 & 0xFF) * (color1 >>> 0 & 0xFF) + 255 >>> 8;
        int comp1 = (color0 >>> 8 & 0xFF) * (color1 >>> 8 & 0xFF) + 255 >>> 8;
        int comp2 = (color0 >>> 16 & 0xFF) * (color1 >>> 16 & 0xFF) + 255 >>> 8;
        int comp3 = (color0 >>> 24 & 0xFF) * (color1 >>> 24 & 0xFF) + 255 >>> 8;
        return comp0 << 0 | comp1 << 8 | comp2 << 16 | comp3 << 24;
    }

    public static int mul(int color, int factor) {
        long hi = ((long)color & 0xFF00FFL) * (long)factor;
        long lo = ((long)color & 0xFF00FF00L) * (long)factor;
        long result = hi + 0xFF00FFL >>> 8 & 0xFF00FFL | lo + 0xFF00FF00L >>> 8 & 0xFF00FF00L;
        return (int)result;
    }

    public static int mul(int color, float factor) {
        return ColorMixer.mul(color, ColorU8.normalizedFloatToByte(factor));
    }
}

